import { ItemStack, Player, world } from "@minecraft/server";
import * as df from "./diamondFunctions.js"
import { DEBUG } from "../config.js";

/**
 * Plays the sound from the form types
 * @param {soundID} sound - The Sound
 * @param {Player} player - The player
 */
export function playSound(sound, player) {
    if (typeof sound == "string") {
        df.runSoundAction(sound, player, sound);
    } else if (typeof sound == "object") {
        if (sound?.target == undefined || sound?.target == "self") {
            df.runSoundAction(sound.soundId, player, sound);
        } else if (sound?.target == "all") {
            const worldPlayers = world.getAllPlayers()
            worldPlayers.forEach(ply => {
                df.runSoundAction(sound.soundId, ply, sound)
            });
        }
    }
}

/**
 * Does the TDP Give Function
 * @param {Object} values - The stuff for the ItemStack
 * @param {Player} player - The Player
 */
export function tdpGive(values, player) {
    const item = new ItemStack(values.itemId, values.amount);
    df.runGiveItem(item, player, undefined);
    if (DEBUG) console.log(`Player ${player.nameTag} recieved ${values.amount} of ${values.itemId.split(":").pop().replace(/^./, str => str.toUpperCase()).replace(/_/g, " ")}`);
}

export async function rawText(text, name='@a', type='text', colour='r'){
    await runCommand(`tellraw @s {"rawtext":[{"text": "§${colour}"},{"${type}": "${text}"}]}`, name);
}

export async function tellRaw(rawtext, name='@a'){
    if (DEBUG) console.log(`Rawtext: `, JSON.stringify(rawtext, null, 2));
    const jsonText = typeof rawtext === "object" ? JSON.stringify(rawtext) : rawtext;
    await runCommand(`tellraw @s ${jsonText}`, name);
}

/**
 * Runs the command
 * @param {string} commands - The command
 * @param {*} source - The source
 */
export async function runCommand(command, source){
    if (DEBUG) console.log(`Command: `, command);
    try {
        if (source == undefined) {
            world.getDimension('overworld').runCommand(command);
            return;
        } else if (typeof source == "object") {
            world.getDimension('overworld').runCommand(command);
        } else if (typeof source == "string" && source.startsWith('@')) {
            world.getDimension('overworld').runCommand(`execute as ${source} at @s run execute positioned as @s run ${command}`);
        } else if (typeof source == "string" && !source.startsWith('@')) {
            world.getDimension('overworld').runCommand(`execute as "${source}" at @s run execute positioned as @s run ${command}`);
        }
    } catch(e){
        console.error(`Error has occur!\nCommand: ${command}\n`, e)
    }
}



/**
 * Runs the commands
 * @param {Array} commands - The list of commands
 * @param {Player} player - The Player
 */
export function runCommands(commands, player){
    commands.forEach((cmd) => player.runCommand(cmd));
}

/**
 * Give a tag to the player
 * @param {tags} tag - The Tag
 * @param {Player} player - The Player
 */
export function giveTag(tag, player) {
    df.runAddTag(tag, player, undefined);
}

/**
 * Removes a tag from the player
 * @param {tags} tag - The Tag
 * @param {Player} player - The Player
 */
export function removeTag(tag, player) {
    df.runRemoveTag(tag, player, undefined);
}

export function changeGM(gamemode, player) {
    df.runGamemode(gamemode, player, undefined);
}

export function teleportAction(values, player) {
    const {location, dimension} = values;
    let dim = "overworld";
    if (dimension == undefined) dim = "overworld";
    else if (dimension != undefined) dim = dimension.toLowerCase().replace(/\s+/g, "_");
    df.runTeleportAction(location, player, undefined, dim);
}

export function summonMobAction(values, player) {
    const {location, entity} = values;
    let loc = location;
    if (!location || location == " ") {
        loc = player;
    }
    if (!entity || entity == " ") {
        console.warn("No valid Entity was provided!");
        return;
    }
    df.runSpawnEntity(location, entity, player, undefined);
}